//
//  PDF417.m
//  22222222222222
//
//  Created by liangchenying on 12-4-8.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PDF417.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface PDF417()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation PDF417

@synthesize PDF417Data;
@synthesize Back;
@synthesize PDF417AppearanceToWidth;
@synthesize PDF417RowsNumber;
@synthesize PDF417ColumnsNumber;
@synthesize PDF417AppearanceToHeight;
@synthesize XSizeButton;
@synthesize LineHeightButton;
@synthesize CorrectionButton;
@synthesize PDF417Print;
@synthesize Cut;

@synthesize pos_sdk		            = _pos_sdk;

@synthesize array_XSize	            = _array_XSize;
@synthesize array_LineHeight	    = _array_LineHeight;
@synthesize array_CorrectionGrade	= _array_CorrectionGrade;

@synthesize selectedXSize	        = _selectedXSize;
@synthesize selectedLineHeight	    = _selectedLineHeight;
@synthesize selectedCorrectionGrade	= _selectedCorrectionGrade;

- (NSMutableArray*)array_XSize
{
    if(_array_XSize  == nil)
    {
        _array_XSize = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_XSize;
}

- (NSMutableArray*)array_LineHeight
{
    if(_array_LineHeight  == nil)
    {
        _array_LineHeight = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_LineHeight;
}

- (NSMutableArray*)array_CorrectionGrade
{
    if(_array_CorrectionGrade  == nil)
    {
        _array_CorrectionGrade = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_CorrectionGrade;
}

- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}

- (NSInteger)NSArrayToInt:(NSMutableArray *)Array  Index:(NSInteger)Index
{
    NSInteger INT;
    NSString *String = nil;
    String = [Array objectAtIndex:Index];
    INT = [String intValue];
    return INT;
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
        //**************************************************************************************************
        //Add object for array_XSize
        [self.array_XSize addObject:@"1"];
        [self.array_XSize addObject:@"2"];
        [self.array_XSize addObject:@"3"];
        [self.array_XSize addObject:@"4"];
        [self.array_XSize addObject:@"5"]; 
        [self.array_XSize addObject:@"6"];
        [self.array_XSize addObject:@"7"];
     
        //**************************************************************************************************
        //Add object for array_LineHeight
	    [self.array_LineHeight addObject:@"2"];
        [self.array_LineHeight addObject:@"3"];
        [self.array_LineHeight addObject:@"4"];
        [self.array_LineHeight addObject:@"5"]; 
        [self.array_LineHeight addObject:@"6"];
        [self.array_LineHeight addObject:@"7"];
		[self.array_LineHeight addObject:@"8"];
        [self.array_LineHeight addObject:@"9"];
        [self.array_LineHeight addObject:@"10"];
        [self.array_LineHeight addObject:@"11"]; 
        [self.array_LineHeight addObject:@"12"];
        [self.array_LineHeight addObject:@"13"];
		[self.array_LineHeight addObject:@"14"];
        [self.array_LineHeight addObject:@"15"];
        [self.array_LineHeight addObject:@"16"];
        [self.array_LineHeight addObject:@"17"]; 
        [self.array_LineHeight addObject:@"18"];
        [self.array_LineHeight addObject:@"19"];
		[self.array_LineHeight addObject:@"20"];
        [self.array_LineHeight addObject:@"21"];
        [self.array_LineHeight addObject:@"22"];
        [self.array_LineHeight addObject:@"23"]; 
        [self.array_LineHeight addObject:@"24"];
        [self.array_LineHeight addObject:@"25"];
     
        //**************************************************************************************************
        //Add object for array_CorrectionGrade
        [self.array_CorrectionGrade addObject:@"0"];
        [self.array_CorrectionGrade addObject:@"1"];
        [self.array_CorrectionGrade addObject:@"2"];
        [self.array_CorrectionGrade addObject:@"3"];
        [self.array_CorrectionGrade addObject:@"4"];
        [self.array_CorrectionGrade addObject:@"5"]; 
        [self.array_CorrectionGrade addObject:@"6"];
        [self.array_CorrectionGrade addObject:@"7"];
        [self.array_CorrectionGrade addObject:@"8"];

    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.selectedXSize           = 3;
    self.selectedLineHeight      = 3;
    self.selectedCorrectionGrade = 0;
    
    [self.PDF417Data               setDelegate:self];
    [self.PDF417AppearanceToWidth  setDelegate:self];
    [self.PDF417RowsNumber         setDelegate:self];
    [self.PDF417ColumnsNumber      setDelegate:self];
    [self.PDF417AppearanceToHeight setDelegate:self];
    
    [self.XSizeButton      setTitle:@"4" forState:UIControlStateNormal];    
    [self.LineHeightButton setTitle:@"5" forState:UIControlStateNormal];    
    [self.CorrectionButton setTitle:@"0" forState:UIControlStateNormal];
    
    [self.PDF417Data               setText:@"abcdefghijklmnopqrstuvwxyz"];
    [self.PDF417AppearanceToWidth  setText:@"1"];
    [self.PDF417AppearanceToHeight setText:@"1"];
    [self.PDF417RowsNumber         setText:@"3"];
    [self.PDF417ColumnsNumber      setText:@"1"];
}

- (void)viewDidUnload
{
    [self setPDF417Data:nil];
    [self setBack:nil];
    [self setPDF417AppearanceToWidth:nil];
    [self setPDF417RowsNumber:nil];
    [self setPDF417ColumnsNumber:nil];
    [self setPDF417AppearanceToHeight:nil];
    [self setXSizeButton:nil];
    [self setLineHeightButton:nil];
    [self setCorrectionButton:nil];
    [self setPDF417Print:nil];
    [self setCut:nil];
    
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

//**************************************************************************************************
//Exit the keyboard by clicking "return"
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.PDF417Data               resignFirstResponder];
        [self.PDF417AppearanceToWidth  resignFirstResponder];
        [self.PDF417RowsNumber         resignFirstResponder];
        [self.PDF417ColumnsNumber      resignFirstResponder];
        [self.PDF417AppearanceToHeight resignFirstResponder];
        return NO;
    } 
return YES;
}

//**************************************************************************************************
//Select XSize(1-7) Index
- (IBAction)selectXSize:(id)sender
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedXSize = selectedIndex;
        [self.XSizeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"XSize" Sheet:self.array_XSize Selected:self.selectedXSize DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Select Line Height(2-25) Index
- (IBAction)selectLineHeight:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedLineHeight = selectedIndex;  
        [self.LineHeightButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Line Height" Sheet:self.array_LineHeight Selected:self.selectedLineHeight DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Select Correction Grade(0-8) Index
- (IBAction)selectCorrectionGrade:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedCorrectionGrade = selectedIndex;   
        [self.CorrectionButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Correction Grade" Sheet:self.array_CorrectionGrade Selected:self.selectedCorrectionGrade DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Print PDF417
- (IBAction)PDF417Print:(id)sender 
{
    SInt32 error_code       = SUCCESS;   
    SInt32 xsize            = 0;
    SInt32 line_height      = 0;
    SInt32 correction_grade = 0;
    SInt32 height           = 0;
    SInt32 width            = 0;
    SInt32 rows_number      = 0;
    SInt32 columns_number   = 0;
    NSData *textNSData      = nil;
    
    //**************************************************************************************************
    //If Data == nil ,barcode cannot be printed
    JudgeParamNil(PDF417Data, @"Data == nil,Please input data");
	
    NSStringEncoding enc= CFStringConvertEncodingToNSStringEncoding(kCFStringEncodingGB_18030_2000);
	textNSData = [self.PDF417Data.text dataUsingEncoding:enc];

    //**************************************************************************************************
    //If AppearanceToHeight == nil ,barcode cannot be printed.
    JudgeParamNil(PDF417AppearanceToHeight, @"AppearanceToHeight == nil,Please input 1-10");
    
    //**************************************************************************************************
    //If AppearanceToWidth == nil ,barcode cannot be printed.
    JudgeParamNil(PDF417AppearanceToWidth, @"AppearanceToWidth == nil,Please input 1-100");
    
    //**************************************************************************************************
    //If RowsNumber == nil ,barcode cannot be printed.
    JudgeParamNil(PDF417RowsNumber, @"RowsNumber == nil,Please input 3-90");
    
    //**************************************************************************************************
    //If columnsnumber == nil ,barcode cannot be printed.
    JudgeParamNil(PDF417ColumnsNumber, @"ColumnsNumber == nil,Please input 1-30");
    
    height         = [self.PDF417AppearanceToHeight.text intValue];    
    //**********************************************************************************************
	//Judge the legitimacy of parameter
    JudgeParamRange(height, 1, 10, @"ERROR Appearance to height! Must be 1-10")
    
    width     = [self.PDF417AppearanceToWidth.text intValue];
    JudgeParamRange(width, 1, 100, @"ERROR Appearance to width! Must be 1-100");
    
    rows_number    = [self.PDF417RowsNumber.text intValue];
    JudgeParamRange(rows_number, 3, 90, @"ERROR Rows! Must be 3-90");
    
    columns_number = [self.PDF417ColumnsNumber.text intValue];
    JudgeParamRange(columns_number, 1, 30, @"ERROR Columns! Must be 1-30");
    
    //**********************************************************************************************
	//Get parameters
    xsize            = [self NSArrayToInt:self.array_XSize Index:self.selectedXSize]; 
    line_height      = [self NSArrayToInt:self.array_LineHeight Index:self.selectedLineHeight]; 
    correction_grade = [self NSArrayToInt:self.array_CorrectionGrade Index:self.selectedCorrectionGrade]; 
    
    //**********************************************************************************************
	//Print PDF417
    error_code = [self.pos_sdk barcodePrintPDF417:textNSData AppearanceToHeight:height AppearanceToWidth:width RowNumber:rows_number ColumnNumber:columns_number XSize:xsize LineHeight:line_height CorrectionGrade:correction_grade];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
    
ExitLine:
    return;
}

- (IBAction)Cut:(id)sender
{
    SInt32 error_code = SUCCESS;
    
    error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:80];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
    
ExitLine:
    return;
}

- (void)dealloc 
{
    [self.PDF417Data release];
    [self.Back release];
    [self.PDF417AppearanceToWidth release];
    [self.PDF417RowsNumber release];
    [self.PDF417ColumnsNumber release];
    [self.PDF417AppearanceToHeight release];
    [self.XSizeButton release];
    [self.LineHeightButton release];
    [self.CorrectionButton release];
    [self.array_XSize release];
    [self.array_LineHeight release];
    [self.array_CorrectionGrade release];
    [self.PDF417Print release];
    [self.Cut release];
    
    [super dealloc];
}

@end
